



<html>
<head>
  <title>javabog.dk -  - Introduktion</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel0.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel2.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">1 <a name='afsn1'></a>Introduktion</H1>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Programmering</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Fordele og
  ulemper ved Java</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">V&aelig;rkt&oslash;jer
  til at programmere i Java</P>
</UL>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Hvis du har lyst til
at komme i gang med at programmere, kan du springe over dette
kapitel.</P>


<H2 CLASS="western" STYLE="">1.1 <a name='afsn1.1'></a>Programmering</SPAN></H2>
<P LANG="da-DK" CLASS="western">Ethvert program, f.eks. et
tekstbehandlingsprogram, regneark, e-post, tegneprogram, spil,
webserver best&aring;r af nogle data (f.eks. hj&aelig;lpefiler og
konfigurationsfiler) og en samling instruktioner til computeren.</P>
<P LANG="da-DK" CLASS="western">Hver instruktion er meget simpel og
computeren udf&oslash;rer den ubetinget, uanset om det er smart eller
ej. Den kan udf&oslash;re instruktionerne ekstremt hurtigt (over 1
milliard pr. sekund) og det kan f&aring; computeren til at virke
smart, selvom instruktionerne er simple.</P>
<H3 CLASS="western">1.1.1 <a name='afsn1.1.1'></a>Styresystemet</H3>
<P LANG="da-DK" CLASS="western">Styresystemet er det program, som
styrer computeren og tillader brugeren at bruge andre programmer. Af
styresystemer kan n&aelig;vnes Linux, Windows, MacOS, UNIX.</P>
<P LANG="da-DK" CLASS="western">Styresystemet styrer computerens
hukommelse og eksterne enheder som sk&aelig;rm, tastatur, mus, disk,
printere og netv&aelig;rksadgang. Det tilbyder tjenester til
programmerne, f.eks. muligheden for at l&aelig;se p&aring; disken
eller tegne en grafisk brugergr&aelig;nseflade.</P>
<P LANG="da-DK" CLASS="western">Et program kan normalt kun k&oslash;re
p&aring; et bestemt styresystem. Javaprogrammer kan dog k&oslash;re
p&aring; flere styresystemer og de bruges derfor bl.a. som
programmer, der automatisk hentes ned til brugerens netl&aelig;ser/browser
og afvikles der. Den type programmer kaldes appletter eller
miniprogrammer.</P>
<H3 CLASS="western">1.1.2 <a name='afsn1.1.2'></a>Hvorfor l&aelig;re at programmere? 
</H3>
<P LANG="da-DK" CLASS="western">Det er sjovt og sp&aelig;ndende og
det kan v&aelig;re en kilde til kreativitet og leg, at skabe sine
egne programmer. Man kan bedre forestille sig nye l&oslash;sninger og
produkter og man f&aring;r bedre kendskab til computeres form&aring;en
og begr&aelig;nsninger. 
</P>
<P LANG="da-DK" CLASS="western">Desuden er det et h&aring;ndv&aelig;rk,
der er efterspurgt blandt IT-virksomheder og mange andre. Ved hj&aelig;lp
af programmering kan du l&oslash;se problemer og du er dermed ikke
mere afh&aelig;ngig af, at andre laver et program, der opfylder dine
behov.</P>
<P LANG="da-DK" CLASS="western">Programmering er en af datalogiens
helt basale discipliner og selv om man ikke arbejder som programm&oslash;r,
er kendskab til programmering en fordel i mange besl&aelig;gtede
fag.</P>
<P LANG="da-DK" CLASS="western">Java er et sprog, der har stor
udbredelse s&aring;vel i industrien som i akademiske kredse. Det er
kraftfuldt og relativt let l&aelig;rt. L&aelig;rer du Java, har
du et godt fundament til at l&aelig;re andre programmeringssprog.</P>
<H3 CLASS="western">1.1.3 <a name='afsn1.1.3'></a>Et simpelt program</H3>
<P LANG="da-DK" CLASS="western">For at computeren kan arbejde, skal
den have nogle instruktioner, den kan f&oslash;lge slavisk. For
at l&aelig;gge to tal, som brugeren oplyser, sammen kunne man
forestille sig f&oslash;lgende opskrift:</P>
<PRE CLASS="kode-western">  1   Skriv &quot;Indtast f&oslash;rste tal&quot; p&aring; sk&aelig;rmen
  2   L&aelig;s tal fra tastaturet
  3   Gem tal i lagerplads A
  4   Skriv &quot;Indtast andet tal&quot; p&aring; sk&aelig;rmen
  5   L&aelig;s tal fra tastaturet
  6   Gem tal i lagerplads B
  7   L&aelig;g indhold af lagerplads A og indhold af lagerplads B sammen
  8   Gem resultat i lagerplads C
  9   Skriv &quot;Summen er:&quot; p&aring; sk&aelig;rmen
  10  Skriv indhold af lagerplads C p&aring; sk&aelig;rmen</PRE><P LANG="da-DK" CLASS="western">
Et program minder lidt om en kogebogsopskrift, som computeren f&oslash;lger
punkt for punkt ovenfra og ned. Hvert punkt (eller instruktion eller
kommando) g&oslash;res f&aelig;rdigt, f&oslash;r der forts&aelig;ttes
til n&aelig;ste punkt.</P>
<H3 CLASS="western">1.1.4 <a name='afsn1.1.4'></a>Hvordan l&aelig;rer man at programmere</H3>
<P LANG="da-DK" CLASS="western">Man l&aelig;rer ikke at programmere
blot ved at l&aelig;se en bog. Har man ikke tid til at &oslash;ve sig
og eksperimentere med det man l&aelig;ser om, spilder man bare sin
tid. For de fleste kr&aelig;ver det en stor arbejdsindsats at l&aelig;re,
at programmere og for alle tager det lang tid, f&oslash;r de
bliver rigtig dygtige til det. 
</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Der er kun &eacute;n
m&aring;de at l&aelig;re at programmere p&aring;: &Oslash;v dig</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Der er blevet lavet forskning, der
underbygger dette. P.M. Cheney konkluderer<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>,
at den eneste betydende faktor i produktiviteten for programm&oslash;rer
er: Erfaring. Han fandt i &oslash;vrigt forskelle i
produktiviteten p&aring; en faktor 25.</P>
<H2 CLASS="western">1.2 <a name='afsn1.2'></a>Fordele og ulemper ved Java</SPAN></H2>
<P LANG="da-DK" CLASS="western">Java er et initiativ til at skabe et
programmeringssprog, der kan k&oslash;re p&aring; flere
styresystemer. Det er udviklet af Sun Microsystems, der i 1991
arbejdede med at designe et programmeringssprog, der var
velegnet til at skrive programmer til fremtidens telefoner, fjernsyn,
opvaskemaskiner og andre elektroniske apparater. S&aring;danne
programmer skal v&aelig;re meget kompakte (begr&aelig;nset
hukommelseslager) og fejlsikre (risikoen for, at apparatet ikke
virker, skal v&aelig;re minimal).</P>
<P LANG="da-DK" CLASS="western">Med udviklingen af internettet blev
Java samtidig meget udbredt, fordi teknologien bl.a. tillader, at sm&aring;
programmer kan l&aelig;gges ind i en hjemmeside (se kapitlet om
appletter).</P>
<H3 CLASS="western">1.2.1 <a name='afsn1.2.1'></a>St&aelig;rke sider</H3>
<P LANG="da-DK" CLASS="western">Sproget har p&aring;
bem&aelig;rkelsesv&aelig;rdigt kort tid udviklet sig, til at v&aelig;re
fremherskende p&aring; grund af dets egenskaber. Java er et
enkelt, objektorienteret, robust, netv&aelig;rksorienteret,
platformuafh&aelig;ngigt, sikkert, fortolket, h&oslash;jtydende,
flertr&aring;det og dynamisk sprog:</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western"><B>Enkelt</B>. Java er i forhold
  til andre programmeringssprog et ret enkelt sprog og det er
  forholdsvis nemt at programmere (specielt for C- og C++
  -programm&oslash;rer). Mange af de muligheder for at lave fejl, der
  eksisterer i andre programmeringssprog, er fjernet i Java.</P>
  <LI><P LANG="da-DK" CLASS="western"><B>Enorm brugerbase</B><SPAN STYLE="font-weight: medium">.
  Java er et af verdens mest popul&aelig;re programmeringssprog<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>.
  De fleste undervisningsinstitutioner har ligeledes valgt Java som
  gennemg&aring;ende sprog i undervisningen.</SPAN></P>
  <LI><P LANG="da-DK" CLASS="western"><B>Objektorienteret</B>. Sproget
  kommer med over 1000 foruddefinerede objekt-typer, som kan udf&oslash;re
  n&aelig;sten enhver t&aelig;nkelig opgave. Pr&aelig;cist hvad
  &quot;objektorienteret&quot; betyder, handler denne bog om.</P>
  <LI><P LANG="da-DK" CLASS="western"><B>Platformuafh&aelig;ngigt</B>.
  Java er platformuafh&aelig;ngigt. Det vil sige, at samme program
  umiddelbart kan udf&oslash;res p&aring; mange forskellige
  styresystemer, f.eks. UNIX, Linux, Mac og Windows, og
  processor-typer f.eks. Intel IA32, PowerPC og Alpha. 
  </P>
  <LI><P LANG="da-DK" CLASS="western"><B>Netv&aelig;rksorienteret</B>.
  Java har indbygget alskens netv&aelig;rkskommunikation (se kapitlet
  om netv&aelig;rk) og bruges meget p&aring; internettet, da
  javaprogrammer kan k&oslash;re p&aring; n&aelig;sten alle platforme.
  Samtidig er Javaprogrammer s&aring; kompakte, at de nemt kan
  indlejres i en hjemmeside.</P>
  <LI><P LANG="da-DK" CLASS="western"><B>Fortolket</B>.
  Java-kildetekst overs&aelig;ttes til en standardiseret
  platformuafh&aelig;ngig kode (kaldet bytekode), som derefter udf&oslash;res
  af en javafortolker p&aring; det enkelte styresystem. Derved opn&aring;s,
  at man kun beh&oslash;ver at overs&aelig;tte sin kildetekst &eacute;n
  gang. Javafortolkeren er en s&aring;kaldt virtuel maskine, der
  konverterer instruktionerne i bytekoden til
  maskinkode-instruktioner, som det aktuelle styresystem kan forst&aring;.</P>
  <LI><P LANG="da-DK" CLASS="western"><B>H&oslash;jtydende</B>. De
  nuv&aelig;rende fortolkere tillader javaprogrammer at blive udf&oslash;rt
  nogenlunde lige s&aring; hurtigt, som hvis de var blevet oversat
  direkte til det p&aring;g&aelig;ldende styresystem.</P>
  <LI><P LANG="da-DK" CLASS="western"><B>Flertr&aring;det</B>. Java er
  designet til at udf&oslash;re flere forskellige programdele
  samtidigt og en programudf&oslash;rsel kan blive fordelt over flere
  CPU'er (se <a href='kapitel17.jsp'>kapitel 17</a> om flertr&aring;det programmering).</P>
  <LI><P LANG="da-DK" CLASS="western"><B>Robust</B>. Under afviklingen
  af et program tjekkes det, at handlingerne er tilladelige og
  opst&aring;r der en fejl, s&aring;som en &oslash;nsket fil ikke kan
  findes, fort&aelig;ller Java, at der er opst&aring;et en undtagelse.
  I mange andre sprog vil s&aring;danne uventede fejl f&oslash;re til,
  at programmet stopper. I Java har man let adgang til at fange
  og h&aring;ndtere disse undtagelser, s&aring; programmet alligevel
  kan k&oslash;re videre (se <a href='kapitel14.jsp'>kapitel 14</a> om undtagelser).</P>
  <LI><P LANG="da-DK" CLASS="western"><B>Sikkert</B>. Et
  sikkerhedssystem tjekker al programkode og s&oslash;rger for, at
  bl.a. hjemmesider med Java-appletter ikke kan g&oslash;re ting, de
  ikke har lov til (f.eks. l&aelig;se eller &aelig;ndre i brugerens
  filer), uden at brugeren selv har givet tilladelse til det.</P>
  <LI><P LANG="da-DK" CLASS="western"><B>Dynamisk</B>. Java kan
  dynamisk (i et k&oslash;rende program) indl&aelig;se ekstra
  programkode fra netv&aelig;rket og udf&oslash;re den, n&aring;r det
  er n&oslash;dvendigt og der er indbygget mekanismer, til at lade
  programmer p&aring; forskellige maskiner dele dataobjekter (se
  f.eks. <a href='kapitel19.jsp'>kapitel 19</a> om RMI).</P>
  <LI><P LANG="da-DK" CLASS="western"><B>&Aring;ben kildekode</B><SPAN STYLE="font-weight: medium">.
  Sun har frigivet kildekoden (se <a href='kapitel1.jsp#afsn1.4.1'>afsnit 1.4.1</a>) til Java, og det st&aring;r
  derfor enhver frit for bl.a. at forbedre eller rette fejl i Java
  (eller f&aring; andre til at g&oslash;re det for sig).</SPAN></P>
</UL>
<H3 CLASS="western">1.2.2 <a name='afsn1.2.2'></a>Stor opbakning</H3>
<P LANG="da-DK" CLASS="western">Ovenst&aring;ende egenskaber g&oslash;r,
at Java ogs&aring; har vundet stor udbredelse i serversystemer de
seneste &aring;r og Java bakkes i dag op af n&aelig;sten alle st&oslash;rre
softwarefirmaer, f.eks. IBM, Oracle, BEA og Borland.</P>
<P LANG="da-DK" CLASS="western">Softwaregiganten Microsoft er en
undtagelse. Microsoft er ikke interesseret i, at programmer kan
udf&oslash;res under andre styresystemer end Windows. Efter at v&aelig;re
blevet kendt skyldig ved domstole i USA og Europa for at misbruge sin
monopollignende magt p&aring; PC-markedet, bl.a. for at skade Java,
ser det dog ud til, at fredelig sameksistens nu hersker.</P>
<H3 CLASS="western">1.2.3 <a name='afsn1.2.3'></a>Svagheder</H3>
<P LANG="da-DK" CLASS="western">Java har ogs&aring; nogle svagheder:</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western">Java kr&aelig;ver en del
  hukommelse (RAM). Store Javaprogrammer kan kr&aelig;ve s&aring;
  meget, at de har problemer med at k&oslash;re p&aring; mindre
  kontor-PC'ere.</P>
  <LI><P LANG="da-DK" CLASS="western">Java skal installeres p&aring;
  en computer, f&oslash;r den kan afvikle javaprogrammer. Hvis man vil
  distribuere sit program, skal man s&aring;ledes pakke en version af
  Java med.</P>
  <LI><P LANG="da-DK" CLASS="western">Java satser p&aring; at v&aelig;re
  platformuafh&aelig;ngigt, men der er alligevel sm&aring; forskelle
  p&aring; de forskellige platforme. Det kr&aelig;ver erfaring og
  afpr&oslash;vning at sikre sig, at ens program virker
  tilfredsstillende p&aring; flere platforme. Dette er ikke kun
  et Java-relateret problem - udviklere af f.eks. hjemmesider har
  tilsvarende problemer. Java g&oslash;r det nemmere at skrive
  platformuafh&aelig;ngige programmer, men det l&oslash;ser ikke alle
  problemer for programm&oslash;ren.</P>
</UL>
<H2 CLASS="western" STYLE="">1.3 <a name='afsn1.3'></a>Programmeringsv&aelig;rkt&oslash;jer
til Java</SPAN></H2>
<P LANG="da-DK" CLASS="western">Under programudviklingen har man brug
for arbejdsredskaber, der kan hj&aelig;lpe en med:</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western">Redigering af kildeteksten.</P>
  <LI><P LANG="da-DK" CLASS="western">Overs&aelig;ttelse af
  kildeteksten til bin&aelig;r kode.</P>
  <LI><P LANG="da-DK" CLASS="western">K&oslash;rsel og fejlfinding.</P>
</UL>
<P LANG="da-DK" CLASS="western">De fleste foretr&aelig;kker at bruge
et grafisk udviklingsv&aelig;rkt&oslash;j (f.eks. JBuilder vist
herunder). De er bygget op med en menulinje &oslash;verst, der
indeholder tilgang til filh&aring;ndtering, projektstyring og alle
n&oslash;dvendige v&aelig;rkt&oslash;jer, hvoraf de vigtigste er
&quot;Run&quot; og &quot;Debug&quot;. &quot;Run&quot; overs&aelig;tter
f&oslash;rst kildeteksten og k&oslash;rer derefter programmet. Uddata
kan ses i en ramme nederst. &quot;Debug&quot; (der findes under
&quot;Run&quot;) bruges til fejlfinding og giver mulighed for at
udf&oslash;re koden trinvist og f&oslash;lge med i variablernes
v&aelig;rdier.</P>
<P LANG="da-DK" CLASS="western">I et udviklingsv&aelig;rkt&oslash;j
arbejder man som regel med et &quot;projekt&quot;, der er en liste
over kildetekst-filer og alle indstillinger for, hvordan programmet
skal k&oslash;res.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">P&aring;
http://javabog.dk kan bogens eksempler, sammen med projektfiler til
de fleste af nedenst&aring;ende programmeringsv&aelig;rkt&oslash;jer,
hentes</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Herunder ses projektet oop.jpr i
venstre side (i v&aelig;rkt&oslash;jet JBuilder). I h&oslash;jre side
ses kildeteksten p&aring; et faneblad. P&aring; de andre
faneblade er typisk designv&aelig;rkt&oslash;j til grafiske
brugergr&aelig;nseflader, dokumentation og versionskontrol.</P>
<H3 CLASS="western">1.3.1 <a name='afsn1.3.1'></a>Borland JBuilder</H3>
<P LANG="da-DK" CLASS="western">En af de meget popul&aelig;re
udviklingsv&aelig;rkt&oslash;j er JBuilder fra Borland. JBuilder er
skrevet i Java og kan derfor bruges p&aring; b&aring;de Linux,
Macintosh, Windows og Sun Solaris. Det anbefales at have 512 MB RAM
eller mere.</P>
<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog2_html_f8c2ec.png" NAME="Grafik2" ALIGN=BOTTOM BORDER=0></P>
<P LANG="da-DK" CLASS="western">Ovenst&aring;ende billede viser,
hvordan JBuilder 2005 og 2006 ser ud. For at bruge bogens eksempler
v&aelig;lges File | Open Project og filen oop_jbuilder.jpx &aring;bnes.
Derefter &aring;bnes krydset ved &lt;Project Source&gt; og en javafil
v&aelig;lges. H&oslash;jreklik og v&aelig;lg 'Run' for at k&oslash;re
den.</P>
<P LANG="da-DK" CLASS="western">Fra og med JBuilder 2007 skiftede
JBuilder til at bygge oven p&aring; Eclipse (se nedenfor), som er
meget kraftfuld, men desv&aelig;rre ikke speciel nem for begyndere:</P>
<P LANG="da-DK" CLASS="western"><IMG SRC="bog2_html_m68e8796c.png" NAME="grafik22" ALIGN=LEFT BORDER=0><BR CLEAR=LEFT>For
at bruge bogens eksempler i JBuilder 2007 v&aelig;lges File | New |
Project... | Java Project from Existing JBuilder .jpx Project, og
filen oop_jbuilder.jpx &aring;bnes. Derefter &aring;bnes oop_jbuilder
| src og en javafil v&aelig;lges. H&oslash;jreklik og v&aelig;lg 'Run
as | Java Application' for at k&oslash;re den.</P>
<P LANG="da-DK" CLASS="western">En basisversion af JBuilder kan
hentes gratis fra <A CLASS="western" HREF="http://www.borland.com/jbuilder">http://www.borland.com/jbuilder</A>.
&Oslash;nsker man adgang til de mere avancerede funktioner (som dog
er un&oslash;dvendige for en begynder og kun forvirrer), skal
programmet k&oslash;bes.</P>

<H3 CLASS="western">1.3.2 <a name='afsn1.3.2'></a>Eclipse.org</H3>

<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog2_html_m36f65259.png" NAME="Grafik21" ALIGN=BOTTOM BORDER=0></P>

<P LANG="da-DK" CLASS="western">IBM har sit eget udviklingsmilj&oslash;
til bl.a. Java, ogs&aring; med &aring;ben kildekode. under navnet
Eclipse. Eclipse, der kr&aelig;ver 512 MB RAM, kan hentes gratis p&aring;
<A CLASS="western" HREF="http://eclipse.org/">http://eclipse.org</A>.
</P>


<H3 CLASS="western">1.3.3 <a name='afsn1.3.3'></a>Oracle JDeveloper</H3>

<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog2_html_m1cb7a8dc.png" NAME="Grafik17" ALIGN=BOTTOM BORDER=0></P>

<P LANG="da-DK" CLASS="western">Databaseproducenten Oracle udgiver
JDeveloper, ogs&aring; skrevet i Java, til bl.a. Linux, Windows og
Macintosh. 
</P>
<P LANG="da-DK" CLASS="western">JDeveloper kan en masse meget
avancerede ting, men er for begyndere lidt mere indviklet at bruge
end JBuilder 2006, bl.a. fordi projekter er samlet i arbejdsomr&aring;der
(eng.: workspace), en facilitet man sj&aelig;ldent har brug for
i starten. Kan du ikke f&aring; fat i JBuilder 2006, er JDeveloper
dog et udm&aelig;rket valg.</P>
<P LANG="da-DK" CLASS="western">JDeveloper kr&aelig;ver mindst 512 MB
RAM. Den fulde udgave kan hentes gratis til privat- og
undervisningsbrug p&aring;
<A CLASS="western" HREF="http://oracle.com/technology/software/products/jdev/">http://oracle.com/technology/software/products/jdev/</A>.</P>
<P LANG="da-DK" CLASS="western">For at bruge bogens eksempler v&aelig;lges
File | Open... og filen oop_jdeveloper.jpr &aring;bnes og der klikkes
OK et par gange. Derefter &aring;bnes krydset ved oop_jdeveloper og
Application Sources og en javafil v&aelig;lges. H&oslash;jreklik og
v&aelig;lg 'Run' for at k&oslash;re den.</P>

<H3 CLASS="western">1.3.4 <a name='afsn1.3.4'></a>NetBeans</H3>

<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog2_html_m1f40a10.png" NAME="Grafik18" ALIGN=BOTTOM BORDER=0></P>

<P LANG="da-DK" CLASS="western">NetBeans er ogs&aring; skrevet i Java
og k&oslash;rer p&aring; Linux, Windows, MacOS og Sun Solaris. 
</P>
<P LANG="da-DK" CLASS="western">Programmet har &aring;ben kildekode
(se <a href='kapitel1.jsp#afsn1.4.1'>afsnit 1.4.1</a>) og kr&aelig;ver 512 MB RAM. Det kan hentes gratis
p&aring; <A CLASS="western" HREF="http://netbeans.org/">http://netbeans.org</A>
og er fint til begyndere.</P>
<P LANG="da-DK" CLASS="western">For at bruge bogens eksempler v&aelig;lges
File | Open Project..., mappen oop-projekt v&aelig;lges (du skal <I>ikke</I>
dobbeltklikke) og der trykkes p&aring; knappen 'Open Project Folder'.
Derefter &aring;bnes oop-projekt | Source Packages og en javafil
v&aelig;lges. H&oslash;jreklik og v&aelig;lg 'Run File' for at k&oslash;re
den.</P>
<H3 CLASS="western" STYLE="">1.3.5 <a name='afsn1.3.5'></a>BlueJ</H3>
<P LANG="da-DK" CLASS="western">Et interessant v&aelig;rkt&oslash;j
til <I>undervisning</I> i objektorienteret programmering er BlueJ.
Det hentes gratis p&aring; <A CLASS="western" HREF="http://bluej.org/">http://bluej.org</A>
og kr&aelig;ver 128 MB RAM. Det har en overskuelig brugergr&aelig;nseflade,
der lader eleven oprette objekter interaktivt, kalde metoder i dem og
se resultatet:</P>
<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog2_html_69178928.png" NAME="Grafik25" ALIGN=BOTTOM BORDER=0></P>
<P LANG="da-DK" CLASS="western">Bogens eksempler er forberedt til
BlueJ (se <a href='kapitel4.jsp#afsn4.10.1'>afsnit 4.10.1</a>). Ovenfor ses s&aring;ledes matadorspillet
fra <a href='kapitel5.jsp'>kapitel 5</a>. &Oslash;verst er klasserne, nederst objekterne som
eleven har oprettet. Til h&oslash;jre ses, hvordan eleven er ved at
kalde metoden transaktion() p&aring; spilleren Jacob. 
</P>
<P LANG="da-DK" CLASS="western">Desv&aelig;rre mangler BlueJ den
avancerede syntaks- og formateringshj&aelig;lp som er tilg&aelig;ngelig
i de st&oslash;rre v&aelig;rkt&oslash;jer og som, efter forfatterens
erfaring, er af afg&oslash;rende betydning for begyndere. 
</P>
<P LANG="da-DK" CLASS="western">Den er derfor fin som supplement men
kan <I>ikke</I> erstatte et &quot;rigtigt&quot; udviklingsv&aelig;rkt&oslash;j.</P>
<H3 CLASS="western">1.3.6 <a name='afsn1.3.6'></a>Andre v&aelig;rkt&oslash;jer</H3>
<P LANG="da-DK" CLASS="western">Der findes mange andre
udviklingsmilj&oslash;er til Java, bl.a. JCreator
(<A CLASS="western" HREF="http://jcreator.com/">http://jcreator.com/</A>
- kr&aelig;ver kun 128 MB RAM, men kun til Windows), IntelliJ
(<A CLASS="western" HREF="http://jetbrains.com/">http://jetbrains.com</A>)
og Simplicity (<A CLASS="western" HREF="http://datarepresentations.com/">http://datarepresentations.com</A>).
De fleste findes i en pr&oslash;veudgave, der kan hentes gratis fra
internettet og som har alle de n&oslash;dvendige faciliteter til at
lave mindre programmer.</P>
<H3 CLASS="western">1.3.7 <a name='afsn1.3.7'></a>Sun JDK</H3>
<P LANG="da-DK" CLASS="western">Den mest skrabede l&oslash;sning man
kan v&aelig;lge at redigere kildeteksterne i, er et
ikke-Java-orienteret program, som for <SPAN STYLE="font-weight: medium">eksempel</SPAN>
Notesblok under Windows eller kedit under Linux.</P>
<P LANG="da-DK" CLASS="western">Til overs&aelig;ttelse og k&oslash;rsel
kan man installere et Java-udviklingskit udgivet af Sun, f.eks. JDK
1.6 (Java Development Kit version 1.6, kaldes ogs&aring; J2SE version
6.0). Det kan hentes gratis p&aring; <A CLASS="western" HREF="http://java.sun.com/">http://java.sun.com</A>
til et v&aelig;ld af styresystemer.</P>
<P LANG="da-DK" CLASS="western">JDK'et bruges fra kommandolinjen
(f.eks. i et DOS-vindue). De vigtigste kommandoer er <B>javac</B>,
der overs&aelig;tter en kildetekstfil til bytekode og <B>java</B>,
der udf&oslash;rer en bytekode-fil.</P>
<H2 CLASS="western">1.4 <a name='afsn1.4'></a>Hj&aelig;lp og videre l&aelig;sning</SPAN></H2>
<P LANG="da-DK" CLASS="western">Mens du l&aelig;ser bogen, kan det
v&aelig;re nyttigt at kigge p&aring;:</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western">Bogens hjemmeside med &oslash;velser
  og ekstra materiale: <A CLASS="western" HREF="http://javabog.dk/">http://javabog.dk</A></P>
  <LI><P LANG="da-DK" CLASS="western">Javadokumentationen:
  <A CLASS="western" HREF="http://java.sun.com/javase/reference/api.jsp">http://java.sun.com/javase/reference/api.jsp</A>
    </P>
  <LI><P LANG="da-DK" CLASS="western">Vejledninger og introduktioner:
  <A CLASS="western" HREF="http://java.sun.com/docs/books/tutorial">http://java.sun.com/docs/books/tutorial</A></P>
  <LI><P LANG="da-DK" CLASS="western">OSS - ofte stillede sp&oslash;rgsm&aring;l
  om alt om Java: <A CLASS="western" HREF="http://jguru.com/faq">http://jguru.com/faq</A>
   
  </P>
  <LI><P LANG="da-DK" CLASS="western">Du kan ogs&aring; deltage i
  diskussionsgruppen dk.edb.programmering.java, hvor man kan f&aring;
  hj&aelig;lp og finde mange relevante sp&oslash;rgsm&aring;l og svar.
  Der er 5-10 indl&aelig;g om dagen. <BR>Har du ikke adgang til
  diskussionsgrupper (eng.: newsgroups), kan de ogs&aring; l&aelig;ses
  via http:<A CLASS="western" HREF="/home">//groups.google.com/</A> .
  Den direkte henvisning
  er:<BR><A CLASS="western" HREF="http://groups.google.com/groups?group=dk.edb.programmering.java">http://groups.google.com/groups?group=dk.edb.programmering.java</A>
    </P>
  <LI><P LANG="da-DK" CLASS="western">Et andet sted med en del
  sp&oslash;rgsm&aring;l og svar er <A CLASS="western" HREF="http://eksperten.dk/">http://eksperten.dk</A>
   under Java.</P>
  <LI><P LANG="da-DK" CLASS="western">Eksemplerne (med kildetekst),
  der f&oslash;lger med, n&aring;r et JDK installeres (kig i
  jdk1.6/demo)</P>
  <LI><P LANG="da-DK" CLASS="western">P&aring; <A CLASS="western" HREF="http://javaspil.dk/">http://javaspil.dk</A>,
  <A CLASS="western" HREF="http://spil.tv2.dk/">http://spil.tv2.dk</A>
  og <A CLASS="western" HREF="http://vredungmand.dk/">http://vredungmand.dk</A>
  kan du se nogle ganske flotte spil skrevet i Java (uden kildetekst).</P>
</UL>

<P LANG="da-DK" CLASS="western">Hvis du efter denne bog vil l&aelig;se
mere om Java p&aring; dansk, kan du kigge p&aring;:</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western">Mine andre b&oslash;ger om
  programmering i Java, p&aring; <A CLASS="western" HREF="http://javabog.dk/">http://javabog.dk</A>.</P>
</UL>
<UL>
  <LI><P LANG="da-DK" CLASS="western">Kristian Hansen: Avanceret
  Java-programmering, Ingeni&oslash;ren|b&oslash;ger, 1998.</P>
  <LI><P LANG="da-DK" CLASS="western">Sk&aring;ne-Sj&aelig;lland
  Linux-brugergruppes javabog: <A CLASS="western" HREF="http://sslug.dk/bog">http://sslug.dk/bog</A>
   
  </P>
</UL>
<H3 CLASS="western">1.4.1 <a name='afsn1.4.1'></a>Projekter med &aring;ben kildekode</H3>
<P LANG="da-DK" CLASS="western">&Aring;ben kildekode (eng.: open
source) vil sige, at kildeteksten er frit tilg&aelig;ngelig. Dette er
i mods&aelig;tning til de fleste kommercielle producenter, der holder
kildeteksten for sig selv.</P>
<P LANG="da-DK" CLASS="western">For en lettere &oslash;vet i Java og
programmering er projekter med &aring;ben kildekode interessante, som
kilde til inspiration og som eksempler p&aring;, hvordan man g&oslash;r
forskellige ting.</P>
<P LANG="da-DK" CLASS="western">Et sted med &aring;ben
kildekode-projekter er <A CLASS="western" HREF="http://sourceforge.net/">http://sourceforge.net</A>,
hvor der er fri adgang til titusindvis af projekter skrevet i Java.
Java-siden <A CLASS="western" HREF="http://foundries.sourceforge.net/java">http://foundries.sourceforge.net/java</A>
 byder p&aring; generelle nyheder om Java og &aring;ben kildekode.</P>
<P LANG="da-DK" CLASS="western">&Aring;ben kildekode blev f&oslash;r
i tiden mest produceret af universiteter og idealistisk indstillede
firmaer og enkeltpersoner. Styresystemet Linux er udelukkende baseret
p&aring; &aring;ben kildekode. 
</P>
<P LANG="da-DK" CLASS="western">Imidlertid er der sket et skred mod
mere og mere &aring;ben kildekode, hvor store firmaer som Novell, Sun
og IBM har f&oslash;rt an. Det er indlysende, at hvis
programudviklingen sker &aring;bent, s&aring;dan at alle kan v&aelig;re
med til at afpr&oslash;ve programmet, komme med forbedringsforslag,
kigge i kildeteksten og selv bidrage til at forbedre programmet, kan
det have en meget positiv indvirkning p&aring; et programs kvalitet
og opbakning blandt brugerne.</P>
<P LANG="da-DK" CLASS="western">Samtidig f&oslash;ler mange, at de
lukkede, propriet&aelig;re systemers tid er ved at v&aelig;re forbi,
b&aring;de fordi man som forbruger er prisgivet producenten m.h.t.
fejlrettelser og nye versioner, men ogs&aring; fordi lukkede systemer
har en indre tendens, til at bev&aelig;ge sig mod st&oslash;rre og
st&oslash;rre monopoler og dermed mindre nyskabelse og sund
konkurrence.</P>
<DIV ID="sdfootnote1">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Artiklen
  hedder 'Effects of Individual Characteristics, Organizational
  Factors and Task Characteristics on Computer Programmer
  Productivity and Job Satisfaction' og kan findes i Information
  and Management, 7, 1984.</P>
</DIV>
<DIV ID="sdfootnote2">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>Se
  f.eks. p&aring; http://www.tiobe.com/tpci.htm</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel0.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel2.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (79% af vrket).
</font>
<br>
nsker du at se de sidste 21% af dette vrk (226970 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
